#!/bin/sh

. /usr/libexec/debug.sh

DebugOn downgrade

# mgd and other ui components are not tolerant of
# stale symlinks
rm_stale_symlinks() {
    local f d ext=$1; shift

    for d in "$@"
    do
        test -d $d || continue
        for f in `find $d -name "*$ext"`
        do
            test -s $f || rm -f $f
        done
    done
}

# See if we have any busted mgd symlinks and remove them.  (PR 1260278 fixes
# the issue in mgd, but since we need to support downgrade to older versions
# that don't contain this fix, use the package framework to remove busted
# symlinks)  This can safely be removed when 17.2 is EOL.
check_mgd_symlinks() {
    if [ -d "/usr/lib/hooks" ]; then
	    find /usr/lib/hooks -type l ! -exec test -e {} \; -exec rm -f {} \;
    fi

    for t in /usr/lib /opt/lib
    do
        for d in dd ffp render
        do
            rm_stale_symlinks .so $t/$d
            rm_stale_symlinks .tlv $t/$d
            rm_stale_symlinks .json $t/$d
        done
    done
    rm_stale_symlinks .pyc /opt/lib/python*/site-packages/*/plugins
    rm_stale_symlinks .slax /var/db/scripts/translation
    rm_stale_symlinks .py /var/db/scripts/translation
}

del_mfsrun_symlinks() {
    # we need to undo /var/run
    test -L /var/run || exit 0
    rm -f /var/run
    mkdir -p /var/run
    if [ -d /var/rundb ]; then
	mv /var/rundb /var/run/db
    else
	mkdir -p /var/run/db
    fi
}

check_mgd_symlinks

DOWNGRADE_SET=${DOWNGRADE_SET:-active}

case "$DOWNGRADE_SET" in
legacy) exit 0;;        # nothing to do
vmhost) del_mfsrun_symlinks;;
*)
   # see if incoming package supports /mfs/var/run
   # (we are now in the previous set)
   unset feature_mfsrun

   if [ -s /usr/libexec/pkg_funcs.sh ]; then
       # for get_xmltags()
       . /usr/libexec/pkg_funcs.sh

       get_xmltags /packages/sets/$DOWNGRADE_SET/junos-runtime feature-mfsrun/
   fi

   if [ -z "$feature_mfsrun" ]; then
       del_mfsrun_symlinks
   fi
   ;;
esac

