#!/bin/sh
#
# $Id$
#
# Copyright 2020, Juniper Networks, Inc
# All Rights Reserved
#

# Ensure we fail to mount on an incompatible kernel
# unless a suitable compat package is available.
kernel_osmajor=`sysctl -qn jnpr.compat.osreldate`
kernel_osmajor=${kernel_osmajor:-`uname -r | sed 's,^JNPR-,,;s,\..*,,'`}
# just incase we are upgraded without kernel and uname is missing
kernel_osmajor=${kernel_osmajor:-`sed -n '/<osmajor>/s,.*>\([1-9][0-9]*\)<.*,\1,p' /packages/sets/active/os-kernel/package.xml`}

test $kernel_osmajor -ge 12 && exit 0
test -s /packages/sets/active/os-compat12/package.xml && exit 0
echo "ERROR: Require 12 kernel support" >&2
exit 1
