#!/bin/sh
#
# $Id$
#
# Copyright 2017, Juniper Networks, Inc
# All Rights Reserved
#

. $PKGTOOLS/pkg_subr.sh

phc_base="/var/tmp/phone-home"
jailpath="$phc_base/jail"
jaildev="$jailpath/dev"
jailvarrun="$jailpath/var/run"
jailvaretc="$jailpath/var/etc"
jailetc="$jailpath/etc"
jailoptlib="$jailpath/opt/lib"
pkg_jailpath='$jailpath'

# This script sets up a jail subsystem to be used by phone-home web-server.
# This is needed only during phone-home operatin and not needed for config
# validation. This activate script implicitly relies on that assumption.
# So, skip running this script when another copy of jphone-home pkg is
# being mounted for config validation.
if [ "$PKG_VALIDATING" = "yes" ]; then
    exit 0
fi

case "${1:-activate}" in
deact*) exit 0;;
activ*)
    # we need jail-runtime
    test -d $PKGSETS/active/jail-runtime || pkg add -v jail-runtime
    test -d $PKGSETS/active/py-base || pkg add -v py-base
    ;;
mounted*)
    if [ -n "$PKGMNT" ]; then
         make_symlink $PKGMNT/jail $jailpath
    fi

    if ! mount -t devfs -o ro,noexec devfs $jaildev; then
        echo "Failed to mount $jaildev"
    fi

    # Check not already mounted and mount dir exists
    mount -t nullfs | grep jphone-home | grep "/var/run" > /dev/null
    if [ $? -ne 0 -a -d /var/run ]; then
        /sbin/mount_nullfs /var/run ${jailvarrun}
    fi
    mount -t nullfs | grep jphone-home | grep "/var/etc" > /dev/null
    if [ $? -ne 0 -a -d /var/etc ]; then
        /sbin/mount_nullfs /var/etc ${jailvaretc}
    fi
    mount -t nullfs | grep jphone-home | grep ^/etc > /dev/null
    if [ $? -ne 0 -a -d /etc ]; then
        /sbin/mount_nullfs /etc ${jailetc}
    fi

    if [ -d $jailpath/rt -a -x /usr/libexec/pkg_mount.sh ]; then
        if ! /usr/libexec/pkg_mount.sh jail-runtime rt $jailpath/rt /; then
            echo "Failed to mount $jailpath/rt"
            ## XXX More cleanup here
        fi
    fi

    if [ -d $jailpath/py -a -x /usr/sbin/pkg_mount ]; then
        if ! /usr/sbin/pkg_mount --skip-symlinks py-base2 py $jailpath/py; then
            echo "Failed to mount $jailpath/py"
        fi

    fi

    ;;
unmount*)
    if [ -d $jailpath ]; then
        pkg_jailpath=`/usr/bin/readlink $jailpath`
    fi

    # Unlink jail mount points here!!
    if [ -d $pkg_jailpath/py -a -x /usr/libexec/pkg_umount.sh ]; then
        /usr/libexec/pkg_umount.sh py-base2 py $pkg_jailpath/py
    fi

    if [ -d $pkg_jailpath/rt -a -x /usr/libexec/pkg_umount.sh ]; then
        /usr/libexec/pkg_umount.sh jail-runtime rt $pkg_jailpath/rt
    fi

    if ! /sbin/umount -t nullfs $jailetc; then
        echo "Failed to unmount /etc file system for HTTPD on $jailetc"
    fi

    if ! /sbin/umount -t nullfs $jailvaretc; then
        echo "Failed to unmount var/etc file system for HTTPD on $jailvaretc"
    fi

    if ! /sbin/umount -t nullfs $jailvarrun; then
        echo "Failed to unmount var/run file system for HTTPD on $jailvarrun"
    fi

    if ! /sbin/umount -t devfs $pkg_jailpath/dev; then
        echo "Failed to unmount device file system for HTTPD on $pkg_jailpath/dev"
    fi

    # Cleanup the softlink to package jail path
    /bin/rm $jailpath

    ;;
esac

