#!/bin/sh
#
# $Id$
#
# Copyright 2014, Juniper Networks, Inc
# All Rights Reserved
#

. $PKGTOOLS/pkg_subr.sh

case "${1:-activate}" in
deact*) 
    echo "Uninstalling jweb-ex-app package.."
    jailexapp='/jail/var/jweb-app/jweb-ex-app'
    if [ -d $jailexapp ]
    then
       echo "Unmounting $jailexapp"  
       umount -f $jailexapp  
       rm -rf $jailexapp
    fi
    chmod a+w /jail/var/jweb-app > /dev/null 

    # Remove all session files to expire user sessions
    rm -f /jail/var/tmp/sess_* > /dev/null
    if [ -f /var/run/http*.pid ]; then
       # Kill off httpd-gk 
       kill `cat /var/run/http*.pid`
    fi
    echo "Successfully uninstalled.."
    ;;
activ*) 
    # we need jweb-ex
    echo "Installing jweb-ex-app package.."
    test -d $PKGSETS/active/jweb-ex || pkg add -v jweb-ex 
    ;;
mounted*)
    echo "Mounting jweb-ex-app.."
    jailexapp='/jail/var/jweb-app/jweb-ex-app'

    if [ ! -d $jailexapp ]
    then
        mkdir -m 0755 -p $jailexapp > /dev/null
    fi

    #make jweb-app readonly
    chmod a-w /jail/var/jweb-app > /dev/null
    rm -f /jail/var/tmp/sess_* > /dev/null
    chmod a-w /jail/var/jweb-app > /dev/null 
    if [ -f /var/run/http*.pid ]; then
       # Kill off httpd-gk using HUP signal to reread the configuration
       # Kill off httpd. Executing a graceful exit. Waiting for all requests to complete.
       kill -HUP `cat /var/run/http*.pid`
       kill -USR1 `ps gax | grep "/httpd --" | grep -v grep | awk '{ print $1 }'`
    fi
    echo "Successfully installed jweb-ex-app."
    ;;
unmount*)
    echo "Unmounting jweb-ex-app.."
    if [ -d $jailexapp ]
    then
       umount -f $jailexapp  
       rm -rf $jailexapp
    fi
    chmod a+w /jail/var/jweb-app > /dev/null 

    # Remove all session files to expire user sessions
    rm -f /jail/var/tmp/sess_* > /dev/null
    if [ -f /var/run/http*.pid ]; then
       # Kill off httpd-gk 
       kill `cat /var/run/http*.pid`
    fi
    echo "Successfully uninstalled.."
    ;;
esac
